/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.util;

import dev.toma.gunsrpg.common.skills.core.SkillCategory;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.common.tileentity.InventoryTileEntity;
import dev.toma.gunsrpg.util.function.ISplitter;
import dev.toma.gunsrpg.util.locate.ammo.ItemLocator;
import java.lang.reflect.Array;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.apache.logging.log4j.util.TriConsumer;

public class ModUtils {
    public static final ISplitter<SkillCategory, SkillType<?>> SKILLS_BY_CATEGORY = ModUtils::splitSkillsIntoCategories;
    public static final DecimalFormatSymbols DOT_DECIMAL_SEPARATOR = new DecimalFormatSymbols();

    public static void addItem(PlayerEntity player, ItemStack stack) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        boolean flag = player.field_71071_by.func_70441_a(stack);
        if (flag && stack.func_190926_b()) {
            stack.func_190920_e(1);
            ItemEntity itementity1 = player.func_71019_a(stack, false);
            if (itementity1 != null) {
                itementity1.func_174870_v();
            }
            player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            player.field_71069_bz.func_75142_b();
        } else {
            ItemEntity itementity = player.func_71019_a(stack, false);
            if (itementity != null) {
                itementity.func_174868_q();
                itementity.func_200217_b(player.func_110124_au());
            }
        }
    }

    public static <T> int indexOf(T[] array, T value) {
        for (int i = 0; i < array.length; ++i) {
            T t = array[i];
            if (!t.equals(value)) continue;
            return i;
        }
        return -1;
    }

    public static <T> void shift(T element, T[] array) {
        int length = array.length;
        if (length > 1) {
            System.arraycopy(array, 0, array, 1, length - 2 + 1);
        }
        array[0] = element;
    }

    public static void inverse(Object[] array) {
        int length = array.length;
        int half = length / 2;
        for (int i = 0; i < half; ++i) {
            int opposite = length - 1 - i;
            Object temp = array[i];
            array[i] = array[opposite];
            array[opposite] = temp;
        }
    }

    public static boolean isWithinPoints(int x, int y, int ax, int ay, int bx, int by) {
        return x >= ax && x <= bx && y >= ay && y <= by;
    }

    public static boolean equals(double value1, double value2, double precision) {
        double diff = Math.abs(value1 - value2);
        return diff <= precision;
    }

    @SafeVarargs
    public static <T> T firstNonnull(T ... values) {
        for (T t : values) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isNullOrEmpty(Object[] arr) {
        return arr == null || arr.length == 0;
    }

    public static String convertToLocalization(ResourceLocation location) {
        return location.toString().replaceAll(":", ".");
    }

    public static <T> T[] trimArray(T[] in, Class<T> cls) {
        return Arrays.stream(in).filter(Objects::nonNull).toArray(size -> (Object[])Array.newInstance(cls, size));
    }

    public static <T> T init(T t, Consumer<T> initializer) {
        initializer.accept(t);
        return t;
    }

    public static <NBT extends INBT> void loadDeserializable(String name, INBTSerializable<NBT> serializable, INBTDeserializer<NBT> deserializer, Supplier<NBT> fallback, CompoundNBT nbt) {
        NBT inbt = deserializer.deserialize(nbt, name);
        serializable.deserializeNBT(inbt != null ? inbt : (INBT)fallback.get());
    }

    public static void loadNBT(String name, INBTSerializable<CompoundNBT> serializable, CompoundNBT source) {
        ModUtils.loadDeserializable(name, serializable, CompoundNBT::func_74775_l, CompoundNBT::new, source);
    }

    public static <T> T getRandomListElement(List<T> list, Random random) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(random.nextInt(list.size()));
    }

    public static void dropInventoryItems(World world, BlockPos pos) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof InventoryTileEntity) {
            ModUtils.dropInventoryItems(((InventoryTileEntity)entity).getInventory(), world, pos);
        }
    }

    public static void dropInventoryItems(LazyOptional<? extends IItemHandler> optional, World world, BlockPos pos) {
        optional.ifPresent(handler -> {
            for (int i = 0; i < handler.getSlots(); ++i) {
                InventoryHelper.func_180173_a((World)world, (double)((double)pos.func_177958_n() + 0.5), (double)pos.func_177956_o(), (double)((double)pos.func_177952_p() + 0.5), (ItemStack)handler.getStackInSlot(i));
            }
        });
    }

    public static <K, V> void noDupInsert(Map<K, V> map, V value, Function<V, K> keyExtractor) {
        ModUtils.noDupInsert(map, keyExtractor.apply(value), value);
    }

    public static <K, V> void noDupInsert(Map<K, V> map, K key, V value) {
        if (map.put(key, value) != null) {
            throw new IllegalStateException("Duplicate key: " + key);
        }
    }

    public static <A> boolean contains(A obj, A[] array) {
        for (A a : array) {
            if (a != obj) continue;
            return true;
        }
        return false;
    }

    public static int clamp(int n, int min, int max) {
        return n < min ? min : Math.min(n, max);
    }

    public static <K, V> V getNonnullFromMap(Map<K, V> map, K key, V def) {
        V v = map.get(key);
        return v != null ? v : Objects.requireNonNull(def);
    }

    public static BlockRayTraceResult raytraceBlocksIgnoreGlass(Vector3d start, Vector3d end, IBlockReader reader) {
        RayTraceContext context = new RayTraceContext(start, end, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null);
        return (BlockRayTraceResult)IBlockReader.func_217300_a((RayTraceContext)context, (ctx, pos) -> {
            BlockState blockstate = reader.func_180495_p(pos);
            FluidState fluidstate = reader.func_204610_c(pos);
            Vector3d vector3d = ctx.func_222253_b();
            Vector3d vector3d1 = ctx.func_222250_a();
            VoxelShape voxelshape = ctx.func_222251_a(blockstate, reader, pos);
            BlockRayTraceResult blockraytraceresult = reader.func_217296_a(vector3d, vector3d1, pos, voxelshape, blockstate);
            VoxelShape voxelshape1 = ctx.func_222252_a(fluidstate, reader, pos);
            BlockRayTraceResult blockraytraceresult1 = voxelshape1.func_212433_a(vector3d, vector3d1, pos);
            double d0 = blockraytraceresult == null ? Double.MAX_VALUE : ctx.func_222253_b().func_72436_e(blockraytraceresult.func_216347_e());
            double d1 = blockraytraceresult1 == null ? Double.MAX_VALUE : ctx.func_222253_b().func_72436_e(blockraytraceresult1.func_216347_e());
            return d0 <= d1 ? blockraytraceresult : blockraytraceresult1;
        }, ctx -> {
            Vector3d vector3d = ctx.func_222253_b().func_178788_d(ctx.func_222250_a());
            return BlockRayTraceResult.func_216352_a((Vector3d)ctx.func_222250_a(), (Direction)Direction.func_210769_a((double)vector3d.field_72450_a, (double)vector3d.field_72448_b, (double)vector3d.field_72449_c), (BlockPos)new BlockPos(ctx.func_222250_a()));
        });
    }

    public static Direction getFacing(PlayerEntity player) {
        float reach = ModUtils.getReachDistance(player);
        Vector3d vec1 = player.func_174824_e(1.0f);
        Vector3d vec2 = player.func_70040_Z();
        Vector3d vec3 = vec1.func_72441_c(vec2.field_72450_a * (double)reach, vec2.field_72448_b * (double)reach, vec2.field_72449_c * (double)reach);
        BlockRayTraceResult result = player.field_70170_p.func_217299_a(new RayTraceContext(vec1, vec3, RayTraceContext.BlockMode.VISUAL, RayTraceContext.FluidMode.NONE, (Entity)player));
        return result != null && result.func_216354_b() != null ? result.func_216354_b() : Direction.NORTH;
    }

    public static float getReachDistance(PlayerEntity player) {
        float attrib = (float)player.func_233637_b_((Attribute)ForgeMod.REACH_DISTANCE.get());
        return player.func_184812_l_() ? attrib : attrib - 0.5f;
    }

    public static int string2colorRgb(String hexCode) {
        return Integer.decode("0x" + hexCode);
    }

    public static <E extends Enum<E>> E getEnumByIdSafely(int id, Class<E> type) {
        Enum[] values = (Enum[])type.getEnumConstants();
        return (E)values[id % values.length];
    }

    public static void encodeInventoryContents(IInventory inventory, PacketBuffer buffer) {
        ArrayList<SerializedSlot> slots = new ArrayList<SerializedSlot>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            SerializedSlot serializedSlot = new SerializedSlot(i, stack);
            slots.add(serializedSlot);
        }
        buffer.writeInt(slots.size());
        slots.forEach(slot -> slot.encode(buffer));
    }

    public static SerializedSlot[] decodeInventoryContents(PacketBuffer buffer) {
        int count = buffer.readInt();
        SerializedSlot[] slots = new SerializedSlot[count];
        for (int i = 0; i < count; ++i) {
            SerializedSlot serializedSlot;
            slots[i] = serializedSlot = SerializedSlot.decode(buffer);
        }
        return slots;
    }

    public static <I> void saveInventoryFromContext(ItemLocator.InventoryContext context) {
        Object object = context.getInventory();
        ItemStack parent = context.getParent();
        if (parent.func_77973_b() instanceof ItemLocator.SaveInventoryProvider) {
            ItemLocator.SaveInventoryProvider provider = (ItemLocator.SaveInventoryProvider)parent.func_77973_b();
            Object inventory = object;
            provider.insertEditedItem(inventory, context.getCurrentSlotIndex(), context.getCurrectStack());
            provider.saveInventory(inventory, context.getParent());
        }
    }

    private static Map<SkillCategory, List<SkillType<?>>> splitSkillsIntoCategories(Iterable<SkillType<?>> iterable) {
        EnumMap map = new EnumMap(SkillCategory.class);
        for (SkillType<?> type : iterable) {
            SkillCategory category = type.getHierarchy().getCategory();
            map.computeIfAbsent(category, cat -> new ArrayList()).add(type);
        }
        return map;
    }

    public static boolean canFitItems(ItemStack[] items, IInventory container, int ... validSlots) {
        int maxIndex = IntStream.of(validSlots).max().orElse(1);
        NonNullList inventory = NonNullList.func_191197_a((int)(maxIndex + 1), (Object)ItemStack.field_190927_a);
        for (int slotIndex : validSlots) {
            ItemStack stack = container.func_70301_a(slotIndex);
            inventory.set(slotIndex, (Object)stack);
        }
        return ModUtils.insertItems(items, inventory, () -> ((IInventory)container).func_70297_j_(), NonNullList::get, NonNullList::set, validSlots);
    }

    public static void insertItems(ItemStack[] items, IInventory container, int ... outputSlots) {
        ModUtils.insertItems(items, container, () -> ((IInventory)container).func_70297_j_(), IInventory::func_70301_a, IInventory::func_70299_a, outputSlots);
    }

    private static <T> boolean insertItems(ItemStack[] items, T t, IntSupplier maxSize, BiFunction<T, Integer, ItemStack> itemGetter, TriConsumer<T, Integer, ItemStack> itemSetter, int[] outputSlots) {
        for (ItemStack itemStack : items) {
            boolean result = ModUtils.insertItem(itemStack.func_77946_l(), t, maxSize, itemGetter, itemSetter, outputSlots);
            if (result) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean insertItem(ItemStack item, T target, IntSupplier maxSize, BiFunction<T, Integer, ItemStack> getter, TriConsumer<T, Integer, ItemStack> setter, int[] slots) {
        int max = maxSize.getAsInt();
        int toInsert = item.func_190916_E();
        int slot = ModUtils.getSlotForItem(item, target, max, getter, slots);
        if (slot == -1) {
            return false;
        }
        ItemStack itemStack = getter.apply(target, slot);
        if (itemStack.func_190926_b()) {
            ItemStack inserted = item.func_77946_l();
            inserted.func_190920_e(Math.min(inserted.func_190916_E(), Math.min(toInsert, max)));
            setter.accept(target, (Object)slot, (Object)inserted);
            toInsert -= inserted.func_190916_E();
        } else if (ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)item)) {
            ItemStack inserted = item.func_77946_l();
            int emptySpace = Math.max(0, max - itemStack.func_190916_E());
            int insertAmount = Math.min(emptySpace, toInsert);
            inserted.func_190920_e(itemStack.func_190916_E() + insertAmount);
            setter.accept(target, (Object)slot, (Object)inserted);
            toInsert -= insertAmount;
        }
        if (toInsert > 0) {
            item.func_190920_e(toInsert);
            return ModUtils.insertItem(item, target, maxSize, getter, setter, slots);
        }
        return true;
    }

    private static <T> int getSlotForItem(ItemStack stack, T target, int max, BiFunction<T, Integer, ItemStack> getter, int[] slots) {
        ItemStack itemStack;
        int slot = -1;
        for (int i : slots) {
            itemStack = getter.apply(target, i);
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)itemStack) || itemStack.func_190916_E() >= max) continue;
            return i;
        }
        for (int i : slots) {
            itemStack = getter.apply(target, i);
            if (!itemStack.func_190926_b()) continue;
            return i;
        }
        return slot;
    }

    static {
        DOT_DECIMAL_SEPARATOR.setDecimalSeparator('.');
    }

    public static interface INBTDeserializer<NBT extends INBT> {
        public NBT deserialize(CompoundNBT var1, String var2);
    }

    public static final class SerializedSlot {
        private final int slotIndex;
        private final ItemStack stack;

        public SerializedSlot(int slotIndex, ItemStack stack) {
            this.slotIndex = slotIndex;
            this.stack = stack;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public ItemStack getItemStack() {
            return this.stack;
        }

        void encode(PacketBuffer buffer) {
            buffer.writeInt(this.slotIndex);
            buffer.func_150788_a(this.stack);
        }

        static SerializedSlot decode(PacketBuffer buffer) {
            return new SerializedSlot(buffer.readInt(), buffer.func_150791_c());
        }

        public static void apply(IInventory inventory, SerializedSlot[] slots) {
            for (SerializedSlot serializedSlot : slots) {
                inventory.func_70299_a(serializedSlot.getSlotIndex(), serializedSlot.getItemStack());
            }
        }
    }
}

